#############################################################################
#############################################################################
#
# latexComm.tcl (called from latex.tcl)
#
#############################################################################
#
# Old Author:  Tom Scavo <trscavo@syr.edu>
# New Author:  Vince Darley <vince@santafe.edu>
#############################################################################
#############################################################################

proc latexComm.tcl {} {}
#--------------------------------------------------------------------------
# TeX applications
#--------------------------------------------------------------------------

# In the following scripts, $quotedSig and $filename are the application 
# signature and the name of the file to be typeset, respectively.  (See
# proc 'evalTeXScript' below.)
array set bibtexAppScripts {
  DirectTeXPro {
    {dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\"; MenuCommand 1 5"}
  }
  CMacTeX {
    {sendOpenEvent noReply $quotedSig $filename}
  }
  BibTeX {
    {sendOpenEvent noReply $quotedSig $filename}
  }
}
array set bibtexAppSignatures {
  CMacTeX CMTu BibTeX Vbib
}
array set dvipsAppScripts {
  DirectTeXPro {
    {dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\";  directory \$dt_TeXProjectDir > CurrDirectory; dvips \$dt_TeXProjectName"}
  }
  CMacTeX {
    {dosc -c $quotedSig -k 'aevt' -e 'odoc' -t 600 -f $filename}
  }
  OzTeX {
    {sendOpenEvent noReply $quotedSig $filename}
  }
}
array set dvipsAppSignatures {
  DirectTeXPro TeX+ CMacTeX CMT1 OzTeX OzDP
}
array set dvipdfAppScripts {
  CMacTeX {
    {dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
  }
}
array set dvipdfAppSignatures {
  CMacTeX CMtb
}
array set makeindexAppScripts {
  DirectTeXPro {
    {dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\"; MenuCommand 1 6"}
  }
  CMacTeX {
    {sendOpenEvent noReply $quotedSig $filename}
  }
  MakeIndex {
    {sendOpenEvent noReply $quotedSig $filename}
  }
}
array set makeindexAppSignatures {
  DirectTeXPro TeX+ CMacTeX CMTt MakeIndex RZMI
}

array set makeglossaryAppSignatures [array get makeindexAppSignatures]
array set makeglossaryAppScripts [array get makeindexAppScripts]

array set printDVIAppScripts {
  Textures {
    {AEBuild $quotedSig aevt pdoc "----" [makeAlis $filename]}
  }
  DirectTeXPro {
    {dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\"; MenuCommand 1 9"}
  }
  CMacTeX {
    {dosc -c $quotedSig -k 'aevt' -e 'pdoc' -r -f $filename}
  }
  OzTeX {
    {dosc -c $quotedSig -k 'aevt' -e 'pdoc' -r -f $filename}
  }
}
array set printDVIAppSignatures {
  Textures *TEX DirectTeXPro TeX+ CMacTeX CMT8 OzTeX OTEX
}
array set texAppScripts {
  DirectTeX {
    {set script "Begin; ChangeTeXProject '$filename' -check -confirm || Exit 0;  Execute \"{dt_TeXProject}\"; TeXMenu -tex -formats;  End  Dev:Null; RunSession 1  Dev:Null"} 
    {dosc -r -c $quotedSig -s $script} 
  }
  Textures {
    {global Texturesconnections} 
    {set TeXjob ""} 
    {
      if {[info exists Texturesconnections]} {
        foreach entry $Texturesconnections {
          if {[lindex $entry 0] == $filename} {
            set TeXjob [lindex $entry 1]
            break
          }
        }
      }
    }   
    {
      if { $TeXjob == "" } {
        set TeXjob [AEBuild -r $quotedSig BSRs Begi "----" [tclAE::build::alis $filename]]
        set TeXjob [string trim [string range $TeXjob 15 end] {\{\}\"}]
        lappend Texturesconnections [list $filename $TeXjob]
      }
    }
    {
      if {[regexp "^%&\[^:\t\]*$" [getText [minPos] [set p [nextLineStart [minPos]]]]]} {
        set fmtname \[getText 2 [incr p -1]]\
        AEBuild -t 1200 $quotedSig BSRs Typf Fmat $fmtname Jobi $TeXjob
      } else {
        AEBuild -t 1200 $quotedSig BSRs Typf Jobi $TeXjob
      }
    }
  }
  DirectTeXPro {
    {dosc -c $quotedSig -s  "if \$dt_TeXFormat = \'\' \"set dt_TeXFormat -x \$dt_DefaultFormat\""} 
    {dosc -c $quotedSig -s  "ProjectMgr -t \$dt_TeXFormat \"$filename\"; MenuCommand 1 4"} 
  }
  CMacTeX {
    {dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
  }
  OzTeX {
    {sendOpenEvent noReply $quotedSig $filename}
  } 
}
# Here's the older version for Textures < 2.1
if {!$TeXmodeVars(useNewerTexturesInterface)} {
  array set texAppScripts {
    Textures {
      {global Texturesconnections} 
      {set TeXjob ""} 
      {
        if {[info exists Texturesconnections]} {
          foreach entry $Texturesconnections {
            if {[lindex $entry 0] == $filename} {
              set TeXjob [lindex $entry 1]
              break
            }
          }
        }
      }   
      {
        if { $TeXjob == "" } {
          set TeXjob [AEBuild -r $quotedSig BSRs Begi]
          set TeXjob [string trim [string range $TeXjob 15 end] {\{\}\"}]
          lappend Texturesconnections [list $filename $TeXjob]
        }
      }   
      {AEBuild -t 1200 $quotedSig BSRs Typs "----" [makeAlis $filename] fmat {"LaTeX"} Jobi $TeXjob} 
    }
  }
}

array set texAppSignatures {
  DirectTeX MPS* Textures *TEX DirectTeXPro TeX+ 
  CMacTeX {*XeT BTxT pXeT pxeT CMTF eXeT} OzTeX OTEX
}
array set viewDVIAppScripts {
  Textures {
    {AEBuild $quotedSig aevt odoc "----" [makeAlis $filename]}
  }
  DirectTeXPro {
    {dosc -c $quotedSig -s "ProjectMgr -t \$dt_TeXFormat	\"[win::Current]\"; MenuCommand 1 8"}
  }
  CMacTeX {
    {dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
  }
  OzTeX {
    {sendOpenEvent noReply $quotedSig $filename}
  }
}
array set viewDVIAppSignatures {
  Textures *TEX DirectTeXPro TeX+ CMacTeX {PIVD CMT8} OzTeX OTEX
}

array set pdflatexAppSignatures {
  pdftex pXeT pdfetex pxeT
}

array set pdflatexAppScripts {
  pdftex {
    {sendOpenEvent noReply $quotedSig $filename}
  }
  pdfetex {
    {sendOpenEvent noReply $quotedSig $filename}
  }
}

######## New stuff FBO 2001-09 ###########
#
# Build a tex command line from the current TeX program and the current
# TeX format (if noFormatNameInFile is on).
proc buildTeXcommand {} {
  global TeXmodeVars
    
  if {$TeXmodeVars(noFormatNameInFile)} {
    # if the name of the format is not in the file, put it
    # in the command line
    if {$TeXmodeVars(fixedFormatNames)} {
      # If the format names are fixed, they do not depend
      # on the name of the TeX program, so their prefix is empty.
      set prefix ""
    } else {
      # Guess the effective name of the format (e.g. pdfelatex) from the
      # generic name of the format (e.g. latex) and the name of the
      # TeX program (e.g. pdfetex). For this, take the prefix of "tex" in
      # the name of the TeX program. Warning: this does not work with the
      # usual names of the Omega formats (omega and lambda).
      if {![regexp {(.*)tex} $TeXmodeVars(nameOfTeXProgram) dummy prefix]} {
        alertnote "Couldn't not determine prefix of \"$TeXmodeVars(nameOfTeXProgram)\""
        return
      }
    }
    set cmdline "$TeXmodeVars(nameOfTeXProgram) &$prefix$TeXmodeVars(nameOfTeXFormat)"
  } else {
    # else, let the program select the format written on the first line of the file
    set cmdline "$TeXmodeVars(nameOfTeXProgram)"
  }
}

# Send a command line to CMacTeX >= 4.0
proc buildNewCMacTeXAE {command filename} {
  return [AEBuild '*XeT' CMTX exec \
   ---- [tclAE::build::TEXT "$command [file tail $filename]"] \
   dest [tclAE::build::alis "[file dirname $filename]:"] \
  ]
}

# From version 4.0, CMacTeX uses one "shell" program: CMacTeX to call the
# real tex programs, so we can't directly use tex, pdftex, etex or pdfetex.
# The early 4.0 version had two shell programs: CMacTeX and CMacETeX (for
# etex and pdfetex), but CMacETeX has been suppressed.
proc TeX::switchCMacTeXInterface {prefName} {
  global TeXmodeVars
  global pdftexAppSignatures pdftexAppScripts
  global pdfetexAppSignatures pdfetexAppScripts
  global texAppSignatures texAppScripts
  global etexAppSignatures etexAppScripts
  global makeindexAppSignatures makeindexAppScripts
  global makeglossaryAppSignatures makeglossaryAppScripts
  global dvipdfAppSignatures dvipdfAppScripts
  global bibtexAppSignatures bibtexAppScripts
  global dvipsAppSignatures dvipsAppScripts
  # Would be MUCH easier to have 2 arrays: appSignature(xxx) and
  # appScripts(xxx). Would avoid missing global declaration or
  # long lists of global declarations...
  
  if {$TeXmodeVars(useNewerCMacTeXInterface)} {
#     alertnote "Switching to new CMacTeX interface"
    array set pdftexAppSignatures {
      CMacTeX *XeT
    }
    
    array set pdftexAppScripts {
      CMacTeX {
        {
          buildNewCMacTeXAE [buildTeXcommand] $filename
        }
      }
    }
    
    array set pdfetexAppSignatures {
      CMacTeX *XeT
    }
    
    array set pdfetexAppScripts {
      CMacTeX {
        {
          buildNewCMacTeXAE [buildTeXcommand] $filename
        }
      }
    }
    
    array set texAppSignatures {
      CMacTeX *XeT
    }
    
    array set texAppScripts {
      CMacTeX {
        {
          buildNewCMacTeXAE [buildTeXcommand] $filename
        }
      }
    }
    array set etexAppSignatures {
      CMacTeX *XeT
    }
    
    array set etexAppScripts {
      CMacTeX {
        {
          buildNewCMacTeXAE [buildTeXcommand] $filename
        }
      }
    }
    
    array set makeindexAppSignatures {
      CMacTeX *XeT
    }
    
    array set makeindexAppScripts {
      CMacTeX {
        {
          global TeX::indexStyle
          if {"${TeX::indexStyle}" == ""} {
            set cmdline "makeindex"
          } else {
            set cmdline \
             "makeindex -s ${TeX::indexStyle}"
          }
          buildNewCMacTeXAE $cmdline $filename
        }
      }
    }
    
    array set dvipdfAppSignatures {
      CMacTeX *XeT
    }
    array set dvipdfAppScripts {
      CMacTeX {
        {
          buildNewCMacTeXAE dvipdfm $filename
        }
      }
    }

    array set makeglossaryAppSignatures {
      CMacTeX *XeT
    }
    
    array set makeglossaryAppScripts {
      CMacTeX {
        {
          global TeX::glossaryStyle
          if {"${TeX::glossaryStyle}" == ""} {
            set cmdline "makeindex"
          } else {
            set cmdline \
             "makeindex -s ${TeX::glossaryStyle}"
          }
          buildNewCMacTeXAE $cmdline $filename
        }
      }
    }
    
    array set bibtexAppSignatures {
      CMacTeX *XeT
    }
    array set bibtexAppScripts {
      CMacTeX {
        {
          global TeXmodeVars
          buildNewCMacTeXAE "bibtex $TeXmodeVars(bibtexOptions)" $filename
        }
      }
    }
    
    array set dvipsAppSignatures {
      CMacTeX *XeT
    }
    array set dvipsAppScripts {
      CMacTeX {
        {
          global TeXmodeVars
          buildNewCMacTeXAE "dvips $TeXmodeVars(dvipsOptions)" $filename
        }
      }
    }
  } else {
#     alertnote "Switching to old CMacTeX interface"
    array set texAppSignatures {
      CMacTeX {*XeT BTxT pXeT pxeT CMTF eXeT}
    }
    
    array set texAppScripts {
      CMacTeX {
        {dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
      }
    }
    
    array set pdftexAppSignatures {
      pdftex pXeT pdfetex pxeT
    }
    
    array set pdftexAppScripts {
      pdftex {
        {sendOpenEvent noReply $quotedSig $filename}
      }
      pdfetex {
        {sendOpenEvent noReply $quotedSig $filename}
      }
    }
    
    array set makeindexAppSignatures {
      CMacTeX CMTt
    }
    
    array set makeindexAppScripts {
      CMacTeX {
        {sendOpenEvent noReply $quotedSig $filename}
      }
    }
    
    array set dvipdfAppScripts {
      CMacTeX {
        {dosc -c $quotedSig -k 'aevt' -e 'odoc' -r -f $filename}
      }
    }
    array set dvipdfAppSignatures {
      CMacTeX CMtb
    }

    array set makeglossaryAppSignatures {
      CMacTeX CMTt
    }
    
    array set makeglossaryAppScripts {
      CMacTeX {
        {sendOpenEvent noReply $quotedSig $filename}
      }
    }
    
    array set bibtexAppSignatures {
      CMacTeX CMTu
    }
    array set bibtexAppScripts {
      CMacTeX {
        {sendOpenEvent noReply $quotedSig $filename}
      }
    }
    
    array set dvipsAppSignatures {
      CMacTeX CMT1
    }
    array set dvipsAppScripts {
      CMacTeX {
        {dosc -c $quotedSig -k 'aevt' -e 'odoc' -t 600 -f $filename}
      }
    }
  }
}
#
#####################

#--------------------------------------------------------------------------
# Typeset submenu commands
#--------------------------------------------------------------------------

proc typeset {{bg 0}} {
  global texSig texAppSignatures TeXmodeVars

  set currentWin [win::TopNonProcessWindow]
  if {$TeXmodeVars(useNewerTexturesInterface)} {
    if {[info exists texAppSignatures(Textures)] && \
     $texSig == $texAppSignatures(Textures)} {
      if {![file exists $currentWin]} {
        switch [askyesno -c "Save current file?"] {
          "yes" {
            saveAs
            set currentWin [win::Current]
          }
          "no" -
          "cancel" {return}
        }
      }
      evalTeXScript tex {TeX app} $currentWin $bg
      return
    }
  }
  # Is there a window open?
  if { $currentWin == "" } {
    typesetFile "" $bg
    return
  }
  # Strip off trailing garbage (if any):
  regexp {(.*) <[0-9]+>} $currentWin dummy currentWin
  # Is the current window part of TeX fileset?
  set fset [isWindowInFileset $currentWin "tex"]
  if { $fset != "" } {
    if [dirtyFileset $fset] {
      switch [askyesno -c "Save current TeX fileset?"] {
        "yes" {saveEntireFileset $fset}
        "no" {
          # do nothing
        }
        "cancel" {return}
      }
    }
    typesetFile [texFilesetBaseName $fset] $bg
    return
  }
  # Is the window untitled or dirty?
  global PREFS
  set currentDoc [file tail $currentWin]
  if { [set num [winUntitled]] } {
    switch [askyesno -c "Save \"$currentDoc\"?"] {
      "yes" {
        if {[catch {set currentWin [saveAs "untitled$num\.tex"]}]} {return}
      }
      "no" {
        set tmpFilename "untitled$num\.tex"
        set text [getText [minPos] [maxPos]]
        if {![file exists [file join $PREFS tmp]]} { file mkdir [file join $PREFS tmp] }
        set newDoc [file join $PREFS tmp $tmpFilename]
        file::writeAll $newDoc $text 1
        set currentWin $newDoc
      }
      "cancel" {return}
    }
  } elseif { [winDirty] } {
    switch [askyesno -c "Save \"$currentDoc\"?"] {
      "yes" {save}
      "no" {
        set text [getText [minPos] [maxPos]]
        if {![file exists [file join $PREFS tmp]]} { file mkdir [file join $PREFS tmp] }
        set newDoc [file join $PREFS tmp temp-$currentDoc]
        file::writeAll $newDoc $text 1
        set currentWin $newDoc
      }
      "cancel" {return}
    }
  }
  # Is the current window TeX-able?
  set ext [file extension $currentWin]
  if {[lsearch -exact $TeXmodeVars(texableFileExtensions) $ext] < 0} {
    # These files are run by tex/latex
    typesetFile "" $bg
  } else {
    # For all others we let the extension determine things
    typesetFile $currentWin $bg
  }
}

proc typesetSelection {} {
  global PREFS TeX::tmpFile
  if { [isSelection] } { 
    watchCursor
    message "processing selection"
    set currentWin [win::Current]
    # Is the current window part of TeX fileset?
    set fset [isWindowInFileset $currentWin "tex"]
    if { $fset == "" } {
      set pos1 [getPos]
      if { [isInDocument] } {
        set pos2 [selEnd]
        if { [isInDocument] } {
          # fall through
        } else {
          beep
          set msg "Selection not in document environment.  Continue?"
          if { [askyesno $msg] == "no" } { return }
        }
      } else {
        beep
        set msg "Selection not in document environment.  Continue?"
        if { [askyesno $msg] == "no" } { return }
        set pos2 [selEnd]
      }
      set body "\r[getText $pos1 $pos2]\r"
      set searchText [getText [minPos] [maxPos]]
    } else {
      set body "\r[getSelect]\r"
      # Will not handle a base file that is open and dirty:
      set searchText [buildFilecontents [texFilesetBaseName $fset]]
    }
    message "building temporary document"
    set pattern {(\\documentclass.*)\\begin\{document\}}
    if { ![regexp -- $pattern $searchText dummy preamble] } {
      set preamble "\\documentclass\{article\}\r"
    }
    set rootFile [file rootname $currentWin]
    set tempFile "temp-[file tail $rootFile]"
    set auxFile $rootFile.aux
    if { [file exists $auxFile] } {
      set latexDoc [buildFilecontents $auxFile $tempFile.aux]
    } else {
      set latexDoc {}
    }
    append latexDoc $preamble [buildEnvironment "document" "" $body "\r"]
    set currentDir [file dirname $currentWin]
    set latexDoc [texResolveAll $latexDoc $currentDir]
    if {![file exists [file join $PREFS tmp]]} {
      file mkdir [file join $PREFS tmp]
    }
    set newFile [file join $PREFS tmp $tempFile.tex]
    file::writeAll $newFile $latexDoc 1
    set lineOffset [expr {[llength [split $latexDoc "\r"]] - [llength [split $body "\r"]] -2}]
    set TeX::tmpFile($newFile) [list selection $currentWin $lineOffset]
    typesetFile $newFile
  } else {
    beep
    message "no selection"
  }
}

proc typesetClipboard {} {
  global PREFS TeX::tmpFile
  set body "\r[getScrap]\r"
  set pat1 {\\begin\{document\}.*\\end\{document\}}
  set pat2 {\\documentclass}
  set preamble "\\documentclass\{article\}\r"
  # Check to see if there's a document environment:
  if {![regexp -- $pat1 $body]} {
    append text $preamble [buildEnvironment "document" "" $body "\r"]
  } else {
    # Check to see if there's a \documentclass command:
    if {![regexp -- $pat2 $body]} {
      append text $preamble $body
    } else {
      set text $body
    }
  }
  if {![file exists [file join $PREFS tmp]]} {
    file mkdir [file join $PREFS tmp]
  }
  set newFile [file join $PREFS tmp temp-noname\.tex]
  file::writeAll $newFile $text 1
  set currentWin $newFile
  set TeX::tmpFile($newFile) "clipboard"
  typesetFile $currentWin
}

# Typeset $filename, but perform no error-checking
#
# proc typesetFile {filename {bg 0}} {
#   global TeXmodeVars
#   if { $filename == "" } {
#     set filename [getfile "Choose a file to typeset:"]
#   }
#   evalTeXScript tex {TeX app} $filename $bg $TeXmodeVars(additionalTeXFlags)
# }

# There are no longer tex, pdftex and so on TeX commands.
# You just typeset a file, what amounts to asking the
# current TeX program to compile the file using the current
# TeX format (or the format on the first line of the file
# is noFormatNameInFile is off.
proc typesetFile {filename {bg 0}} {
  global TeXmodeVars
  if { $filename == "" } {
    set filename [getfile "Choose a file to typeset:"]
  }
  evalTeXScript $TeXmodeVars(nameOfTeXProgram) "$TeXmodeVars(nameOfTeXProgram) app" $filename $bg $TeXmodeVars(additionalTeXFlags)
}

# Apply $op to a file with extension $ext.  (See latexMenu.tcl for
# many examples.)  If 'forcecurrent == 1', use the current window 
# even if it belongs to a TeX fileset.
#
proc doTypesetCommand {op {ext ""} {forcecurrent 0}} {
  if { [set filename [findAuxiliaryFile $ext $forcecurrent]] != "" } {
    if { $op == "open" } { 
      edit -r -m -w $filename 
    } else {
      if {$ext == ""} {
        set ext "TEX"
      }
      $op${ext}File $filename
    }
  } else {
    beep
    alertnote "No $ext file found!"
  }
}

proc viewDVIFile {filename} {
  evalTeXScript viewDVI {DVI viewer} $filename
}

proc viewPDFFile {filename} {
  evalTeXScript viewPDF {PDF viewer} $filename
}

proc printDVIFile {filename} {
  evalTeXScript printDVI {DVI print driver} $filename
}

proc dvipsDVIFile {filename} {
  evalTeXScript dvips {DVI-to-PS filter} $filename
}

proc dvipdfDVIFile {filename} {
  evalTeXScript dvipdf {DVI-to-PDF filter} $filename
}

proc viewPSFile {filename} {
  if {[catch {evalTeXScript viewPS {PS viewer} $filename}]} {
    message "View aborted."
  }
}

proc printPSFile {filename} {
  evalTeXScript printPS {PS print driver} $filename
}

proc distillPSFile {filename} {
  evalTeXScript convertPStoPDF {PS-to-PDF filter} $filename
}

proc bibtexAUXFile {filename} {
  evalTeXScript bibtex {BibTeX app} $filename
}

proc makeindexIDXFile {filename} {
  evalTeXScript makeindex {MakeIndex app} $filename
}

# proc makeindexGLOFile {filename} {
#   evalTeXScript makeindex {MakeIndex app} $filename
# }
proc makeindexGLOFile {filename} {
  evalTeXScript makeglossary {MakeIndex app} $filename
}

proc pdflatexTEXFile {filename} {
  evalTeXScript pdflatex {pdflatex app} $filename
}

proc evalTeXScript {op prompt filename {runAppInBackground 0} {flags ""}} {
  global showTeXLog
  if {[info exists showTeXLog]} {
      app::execute -op $op -prompt $prompt -filename $filename \
	-runAppInBackground $runAppInBackground -showLog $showTeXLog \
	-flags $flags
  } else {
      app::execute -op $op -prompt $prompt -filename $filename \
	-runAppInBackground $runAppInBackground -showLog 0 \
	-flags $flags
  }
  makeProcessMenu
  # this code needs a mechanism for waiting for the TeX run to complete
  if {0 && !$runAppInBackground && ($showTeXLog == 2)} {
    set fname [file tail $filename]
    set curr [file tail [win::Current]]
    if {[file extension $curr] == ".log" && ([file root $fname] == [file root $curr])} {
      return
    } else {
      set fname [file root $filename]
      file::openQuietly ${fname}.log
    }
  }
}

# Two bugs in 'getfile' (see "alpha.bugs58"):
proc openAnyTeXFile {} {
  set	filename [getfile "" [win::Current]]
  if { ![string length $filename] } return
  edit -r -m -w $filename
}

proc removeAuxiliaryFiles {} {
  set word ""
  set removeSilently 0
  set currentWin [win::Current]
  if { $currentWin == "" } { return }
  set currentDir [file dirname $currentWin]
#   set extensions {.ps .dvi .log .aux .bbl .idx .ind .glo .gls \
#    .toc .lof .lot .blg .ilg}
  foreach ext $TeXmodeVars(auxFileExtensions) {
    message "Checking for *$ext files"
    set files [glob -nocomplain -dir $currentDir *$ext]
    foreach file $files {
      set word " more"
      if {$removeSilently} {
        if {[catch {
          foreach f [glob -nocomplain -dir $currentDir *$ext] {
            file delete $f
          }
        }]} {
          alertnote "not all \"*$ext\" files deleted"
        }
        break
      } else {
        message ""
        set filename [file tail $file]
        switch [buttonAlert "Remove \"$filename\"?" "yes" "no" {rm ext} {rm all} "cancel"] {
          "yes" {
            message "Removing $filename"
            if {[catch {file delete [file join $currentDir $filename]}]} {
              alertnote "\"$filename\" not deleted"
            } else {
              message $filename
            }
          }
          "no" {}
          "rm ext" {
            if {[catch {
              foreach f [glob -nocomplain -dir $currentDir *$ext] {
                file delete $f
              }
            }]} {
              alertnote "not all \"*$ext\" files deleted"
            }
            break
          }
          "rm all" {
            if {[catch {
              foreach f [glob -nocomplain -dir $currentDir *$ext] {
                file delete $f
              }
            }]} {
              alertnote "not all \"*$ext\" files deleted"
            }
            set removeSilently 1
            break
          }
          "cancel" {return}
        }
      }
    }
  }
  message "No$word files found"
}

#--------------------------------------------------------------------------
# Utility procs:
#--------------------------------------------------------------------------

# Find a LaTeX auxiliary file with extension $ext.  If 'forcecurrent' 
# is true, search the current directory without checking for TeX filesets.
#
proc findAuxiliaryFile {ext {forcecurrent 0}} {
  set currentWin [win::TopNonProcessWindow]
  if { $currentWin == "" } { return "" }
  set currentDoc [file tail $currentWin]
  
  if {$ext == ""} {
    set ext [string toupper [string range [file extension $currentDoc] 1 end]]
  }

  if {$forcecurrent} {
  # pretend there are no TeX filesets:
    set fset ""
  } else {
    set fset [isWindowInFileset $currentWin "tex"]
  }
  
  if { $fset != "" } {
    set currentWin [texFilesetBaseName $fset]
    set currentDoc [file tail $currentWin]
    set currentDir [file dirname $currentWin]
    set docBasename [file rootname $currentDoc]
    set lowerExt [string tolower $ext]
  } else {
    # we do all this if it's not a project:
    set currentDir [file dirname $currentWin]		
    set docBasename [file rootname $currentDoc]
    set lowerExt [string tolower $ext]
    
    # Is the window untitled or dirty?
    global PREFS
    if { [set num [winUntitled]] } {
      set filename [file join $PREFS tmp Untitled$num\.$lowerExt]
      if { [file exists $filename] } {
        return $filename
      } else {
        return ""
      }
    } elseif { [winDirty] } {
      switch [askyesno "Window dirty---continue anyway?"] {
        "yes" {
          set filename [file join $PREFS tmp temp-$currentDoc\.$lowerExt]
          if { [file exists $filename] } {
            return $filename
          } else {
            # fall through
          }
        }
        "no" {return -code return ""}
      }
    }
  }
  
  # Check the current directory:
  set filename [file join $currentDir $docBasename\.$lowerExt]
  if { [file exists $filename] } {
    return $filename
  } else {
    return ""
  }
}

# If the current window is untitled, return its number (i.e., either
# the number 1 or the number  n  in "untitled <n>"); otherwise, return 0.
proc winUntitled {} {
  set currentWin [win::TopNonProcessWindow]
  if { $currentWin == "" } { return 0 }
  set currentDoc [file tail $currentWin]
  if { [string match $currentWin $currentDoc] } {
    if { [regexp {<(.*)>} $currentDoc dummy num] } {
      return $num
    } else {
      return 1
    }
  } else {
    return 0
  }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "texApp" --
 # 
 #  Switch to bibtex, latex or makeindex
 # -------------------------------------------------------------------------
 ##
proc texApp {name} {
  set type [string tolower $name]
  global ${type}Sig ${type}AppSignatures
  set supportedApps [array names ${type}AppSignatures]
  foreach app $supportedApps { eval lappend sigs [set ${type}AppSignatures($app)] }
  set longPrompt "Please locate your ${name} app."
  if { [catch {app::launchAnyOfThese $sigs ${type}Sig $longPrompt} appname] } {
    error "bug in 'app::launchAnyOfThese'"
  }
  set quotedSig "'[string trim [set ${type}Sig] {'}]'"
  switchTo $quotedSig
}

######## New stuff FBO 2001-09 ############
# Update the list of available formats and the "TeX Format" menu
# when the noFormatNameInFile preference is switched.
# You can give 0 for the 2nd optional argument to build the list
# of format without updating the menu (for instance when the TeX 
# menu is not yet built).
proc TeX::switchFmtNameInFile {prefName {updateMenu 1}} {
  global TeXmodeVars menu::items
  
  if {$TeXmodeVars(fixedFormatNames)} {
  # Format names are fixed, so there is nothing to
  # change to their names.
    return
  }

  if {$TeXmodeVars(noFormatNameInFile)} {
#     alertnote "Switching to NoFormatNameInFile"
    # When switching to noFormatNameInFile, we must suppress
    # redondent formats (e.g tex, etex, pdftex and pdfetex are
    # all the "tex" format for different TeX engines).
    foreach fmt $TeXmodeVars(availableTeXFormats) {
      regexp {(pdf)?e?(.*)} $fmt dummy drop fmt
      lappend newfmt $fmt
    }
    set TeXmodeVars(availableTeXFormats) [lunique $newfmt]
  } else {
#     alertnote "Switching to PutFormatInFile"
    # When switching from noFormatNameInFile, we must built a
    # new list of format by guessing the names of each existing
    # format for each TeX program. So latex will give birth
    # to latex, elatex, pdflatex and pdfelatex if the available
    # TeX programs are tex, etex, pdftex and pdfetex.
    foreach fmt $TeXmodeVars(availableTeXFormats) {
      foreach tapp $TeXmodeVars(availableTeXPrograms) {
        if {[regexp {(.*)tex} $tapp dummy appPrefix]} {
          lappend newfmt $appPrefix$fmt
        } else {
          lappend newfmt $tapp$fmt
        }
      }
    }
    set TeXmodeVars(availableTeXFormats) $newfmt
  }
  set "menu::items(TeX Format)" $TeXmodeVars(availableTeXFormats)
  if {$updateMenu} {
    buildLaTeXMenuQuietly
    foreach itm $TeXmodeVars(availableTeXFormats) {
      markMenuItem {TeX Format} $itm off
    }
    if {$TeXmodeVars(noFormatNameInFile)} {
      markMenuItem {TeX Format} $TeXmodeVars(nameOfTeXFormat) on
    }
  }
}
